<%@ include file="/jsp/init.jsp" %>

<portlet:actionURL var="saveEntry">
	<portlet:param name="javax.portlet.action" value="doAction"/>
	<portlet:param name="action" value="saveEntry"/>
	<portlet:param name="entry" value="soc"/>
</portlet:actionURL>

<style>
	.socSection{
	    border: thin solid #d9d9d9;
	    background-color: #f0efef;
		font-weight: bold;
		margin: 1px;
		padding: 3px;
		width: 99%;
	}
	.socSummaryTable table, th, td{
	    border: thin solid #d9d9d9;
	    border-collapse: collapse;
	    margin: 12px;
	    padding: 5px;
	    text-align: center;
	}
	.socSummaryTable tr:hover {
		background-color: #f5f5f5;
	}
	.socSummaryTable th {
	    background-color: #f0efef;
	}
	.soc-questions {
	    border: thin solid #d9d9d9;
	    float: left;
	    padding: 10px;
	    margin: 8px 8px 8px 12px ;
	    width: 85%;
	    background-color:  #F0F0F0;
	}
	.soc-questions:hover{
		background-color:  #E0E0E0;
	}
	.soc-question-header{
		font-size: larger;
	}
	.soc-content{
		padding: 1% 0 0 1.5%;
		font-size: larger;
	}
	.soc-questions-expanded, 
	.soc-questions-expanded:hover{
		background-color:  #FFFFFF;
	}
	.soc-answer {
    	padding: 30px;
	}
	.soc-textarea{
		width: 70%;
	}
	.soc-text-underline {
		text-decoration: underline;
	}
	.soc-question-header em,
	.soc-content em { 
		text-decoration:underline; 
		font-style: normal;
	}
</style>
		

<form name="socEntry" id="socEntry" method="post" action="${saveEntry}" >
	<input type="hidden" name="soc_callId" value="${call.callId}" >
	<input type="hidden" name="caller_primaryKey" value="${call.callerPersnId}" >
	<input type="hidden" name="TRACKER" value="${TRACKER}" >
	
	<input type="hidden" name="soc_attemptNum" value="${form_['attemptNum']}" >
	<input type="hidden" name="soc_persnId" value="${form_['loggedPersnId']}" >
	<aui:input type="hidden" id="soc_tresholdMet" name="soc_tresholdMet" value=""/>
	

<!-- 
	<div class="socSection">SOC History</div>
	<div class="socSummaryTable">
	<table style="width:50%">
	  <tr>
	    <th width="10%">Attempt #</th>
	    <th width="40%">Date and Time</th> 
	    <th width="50%">CSL Staff</th>
	  </tr>
	  <tr>
	    <td>1</td>
	    <td>${form_['socDateTime1']}</td> 
	    <td>${form_['socCsl1']}</td>
	  </tr>
	    <tr>
	    <td>2</td>
	    <td>${form_['socDateTime2']}</td> 
	    <td>${form_['socCsl2']}</td>
	  </tr>
	    <tr>
	    <td>3</td>
	    <td>${form_['socDateTime3']}</td> 
	    <td>${form_['socCsl3']}</td>
	  </tr>  
	</table>
	</div>
 -->
	
	<div class="sectionHeading">SOC History</div>	
	<div class="socSummaryTable">
	<table style="width:70%">
		<tr>
		  <th width="10%">SOC Id</th> 
		  <th width="10%">Attempt #</th> 	  
		  <th width="20%">Threshold Met?</th> 
		  <th width="30%">Date and Time</th>
		  <th width="30%">Created By</th>
		</tr>

		<c:if test="${form_['numOfSoc'] gt 0}">
			<c:forEach var="oneSoc" items="${form_['soc-history']}" >
			  <tr>
			    <td>${oneSoc.soc.clSocId}</td>
			    <td>${oneSoc.soc.attemptNum}</td>
			    <td>${oneSoc.soc.tresholdMet}</td>
			    <td>${oneSoc.formattedCreatedDate}</td> 
			    <td>${oneSoc.createdByName}</td> 
			  </tr>
			</c:forEach>
		</c:if>
		<c:if test="${form_['numOfSoc'] eq 0}">
			<tr>
				<td colspan=5>No previous SOC</td>
			</tr>
		</c:if>
	</table>
	</div>
	

		<div class="socSection">SOC Questions</div>
		<div id="q1" class="soc-questions">
		<div id="q1Header" class="soc-question-header">1. "Hello. Is '<em>${form_['callerName']}</em>' available?"</div>
		<div id="q1Content" class="soc-content">	
		    <aui:input type="radio" name="soc_callerAvailable" label="yes" value="Yes" onClick="showDiv(2,14)"></aui:input>
		    <aui:input type="radio" name="soc_callerAvailable" label="no" value="No" onClick="hideDiv(2,14)"></aui:input>   
			<ul type="square">
				<li>
					If no, "Thank you. No message. I will try again tomorrow."
					<ul type="circle">
						<li>
							If the person asks who you are:
							<br>
							"I am calling from the VA to follow up on a recent phone call. No message. I will try again another time." Indicate you are calling from VA, but avoid disclosing the CSL in order to protect caller privacy.					
						</li>
						<li>If you receive voicemail, do not leave a message.</li>		
						<li>
							If the caller asks you to call back at a different time, please note the requested time. If this occurs during the 2nd attempt, a 3rd attempt will be made if it is at the request of Caregiver.
							<br>
							<textarea name="soc_requestedCallbackTime" rows="5" style="width:70%;"></textarea>				
						</li>	
					</ul>
				</li>
			</ul>
		</div>
		</div>


		<div id="q2" class="soc-questions">
		<div id="q2Header" class="soc-question-header">2. If you speak to the caller:</div>
		<div id="q2Content" class="soc-content">
			"My name is <em>${form_['loggedUserName']}</em> and I am calling from the VA Caregiver Support Line. I'm calling to follow up about your call on <em>${form_['callDate']}</em> to ensure you are satisfied with the support we provided. Generally, the questions that I would like to ask you just a few minutes to complete. Are you willing to answer a few questions?"			
			<aui:input type="radio" name="soc_willingToAnsQues" label="yes" value="Yes" onClick="showDiv(3,14)"/>
		    <aui:input type="radio" name="soc_willingToAnsQues" label="no" value="No" onClick="hideDiv(3,14)"/>   
			<ul type="square">
				<li>If yes, proceed to question 3.</li>
				<li>If no, "Okay. Thank you for your time and please call us again if we may be of assistance."</li>
			</ul>
		</div>
		</div>

		
		<div id="q3" class="soc-questions">		
		<div id="q3Header" class="soc-question-header" >3. Our records show you called the support line regarding </div>
		<div id="q3Content" class="soc-content" >
			<ul>
				<c:forEach var="boxGrp" items="${form_['public-law-111-163-reasons']}" >
					<c:if test="${boxGrp_[boxGrp.primaryKey] eq true}">
						<li>${boxGrp.label}</li>
					</c:if>
				</c:forEach>
			</ul>
			Is that correct?
		
			<aui:input type="radio" name="soc_calledCsl" label="yes" value="Yes"/>
		    <aui:input type="radio" name="soc_calledCsl" label="no" value="No"/>   			
			<ul type="square">
				<li>If caller indicates they didn't call about the subject described give them time to clarify. This will allow the respondent to reply based on memory. If they have difficulty recalling, you could also read the recorded reason and ask them to verify the reason.</li>
			</ul>
		</div>
		</div>		

		
		<div id="q4" class="soc-questions">		
		<div id="q4Header" class="soc-question-header" >4. We'd like to know what you thought about the person who answered your call.</div>
		<div id="q4Content" class="soc-content" >
			Regarding the knowledge of the person that responded to your call - would you say that person was:
			<br>
			<aui:input type="radio" name="soc_cslKnowledgable" label="not_knowledgeable" value="Not Knowledgeable"/>
		    <aui:input type="radio" name="soc_cslKnowledgable" label="somewhat_knowledgeable" value="Somewhat Knowledgeable"/>   			
			<aui:input type="radio" name="soc_cslKnowledgable" label="very_knowledgeable" value="Very Knowledgeable"/>			
			<br>
			Did you feel the person that you talked with was:
			<br>
			<select name="soc_cslSupportive">
				<option value="">Select</option>
				<option value="Not Supportive">Not Supportive</option>
				<option value="Somewhat Supportive">Somewhat Supportive</option>
				<option value="Very Supportive">Very Supportive</option>
			</select>
		</div>		
		</div>
		
			
		<div id="q5" class="soc-questions">
		<div id="q5Header" class="soc-question-header" >5. Callers to the support line are often given information on local resources. When you called the line, did the person you talked to suggest any local community resources?</div>
		<div id="q5Content" class="soc-content" >
		    <aui:input type="radio" name="soc_localResSuggested" label="yes" value="Yes" onClick="showDiv(6,7)"></aui:input>
		    <aui:input type="radio" name="soc_localResSuggested" label="no" value="No" onClick="hideDiv(6,7)"></aui:input>   
		    <aui:input type="radio" name="soc_localResSuggested" label="unsure-dont-remember" value="Unsure/Don't remember" onClick="showDiv(6,7)"></aui:input>
			<br>
			<ul type="square">
				<li>IF YES, and/or person confirms community resources were shared, proceed to question 6</li>
				<li>If NO, SKIP TO QUESTION 8</li>
				<li>If unsure or don't remember, prompt:  "According to our records the call responder shared information about (these resources)."
					<ul>
						<li>CSP Local Resource - example 1</li>
						<li>CSP Local Resource - example 2</li>
						<li>CSP Local Resource - example 3</li>
					</ul>			
				</li>
			</ul>
		</div>
		</div>
		

		<div id="q6" class="soc-questions">
		<div id="q6Header" class="soc-question-header" >6. We would like to know if these resources were helpful to you, so I would like to ask you some questions about these resources.</div>
		<div id="q6Content" class="soc-content" >
			Were you able to successfully contact the resource?
			<br>
		    <aui:input type="radio" name="soc_localResContacted" label="yes" value="Yes" onClick="showDiv(7,7)"></aui:input>
		    <aui:input type="radio" name="soc_localResContacted" label="no" value="No" onClick="hideDiv(7,7)"></aui:input>   
		    <aui:input type="radio" name="soc_localResContacted" label="na" value="NA" onClick="showDiv(7,7)"></aui:input>
			<br>
			<ul type="square">
				<li>If YES, go to question 7</li>
				<li>If NO, f/u question - Why were you unable to contact them? Go to question 8
					<br>
					<select  name="soc_whyLocalResNotContacted">
						<option value="">Select</option>
						<option value="Did not attempt">Did not attempt</option>
						<option value="Plan to attempt in the future" >Plan to attempt in the future</option>
						<option value="No longer interested">No longer interested</option>
						<option value="Other" >Other</option>
						<option value="NA" >NA</option>
					</select>				
				</li>
			</ul>
		</div>
		</div>			


		<div id="q7" class="soc-questions">
		<div id="q7Header" class="soc-question-header" >7. Was the resource helpful?</div>
		<div id="q7Content" class="soc-content" >	
			<select name="soc_localResHelpful">
				<option value="">Select</option>
				<option value="Yes">Yes</option>
				<option value="No" >No</option>
				<option value="Unsure" >Unsure</option>
				<option value="NA" >NA</option>
			</select>
		</div>
		</div>
		

		<div id="q8" class="soc-questions">
		<div id="q8Header" class="soc-question-header" >8. Now, I'd like to ask a few more general questions about your experience using our support line.</div>
		<div id="q8Content" class="soc-content" >
			You called the support line for [describe reason given above].When the call ended, did you feel like your question/s or concern/s was/were answered?
			<br>
			<aui:input type="radio" name="soc_concernsAnswered" label="yes" value="Yes"/>
		    <aui:input type="radio" name="soc_concernsAnswered" label="no" value="No"/>   			
			<aui:input type="radio" name="soc_concernsAnswered" label="unsure" value="Unsure"/>
			<aui:input type="radio" name="soc_concernsAnswered" label="na" value="NA"/>
		</div>
		</div>


		<div id="q9" class="soc-questions">
		<div id="q9Header" class="soc-question-header" >9. When the call ended, did you understand what the next steps were?</div>
		<div id="q9Content" class="soc-content" >	
			<aui:input type="radio" name="soc_understandNextSteps" label="yes" value="Yes"/>
		    <aui:input type="radio" name="soc_understandNextSteps" label="no" value="No"/>   			
			<aui:input type="radio" name="soc_understandNextSteps" label="unsure" value="Unsure"/>
		</div>
		</div>


		<div id="q10" class="soc-questions">
		<div id="q10Header" class="soc-question-header" >10. If you had another Caregiving need, how likely would you be to call the VA Caregiver Support Line again?</div>
		<div id="q10Content" class="soc-content" >
			<aui:input type="radio" name="soc_callCslAgain" label="very-likely" value="Very Likely"/>
		    <aui:input type="radio" name="soc_callCslAgain" label="somewhat-likely" value="Somewhat Likely"/>   			
			<aui:input type="radio" name="soc_callCslAgain" label="not-likely" value="Not Likely"/>
		</div>
		</div>


		<div id="q11" class="soc-questions">
		<div id="q11Header" class="soc-question-header" >11. How likely would you be to recommend the support line to another Caregiver?</div>
		<div id="q11Content" class="soc-content">
			<aui:input type="radio" name="soc_recommendCsl" label="very-likely" value="Very Likely"/>
		    <aui:input type="radio" name="soc_recommendCsl" label="somewhat-likely" value="Somewhat Likely"/>   			
			<aui:input type="radio" name="soc_recommendCsl" label="not-likely" value="Not Likely"/>
		</div>
		</div>
		

		<div id="q12" class="soc-questions">
		<div id="q12Header" class="soc-question-header" >12. What suggestions do you have to improve our Caregiver support line?</div>
		<div id="q12Content" class="soc-content" >
			<textarea name="soc_suggestions" rows="5" style="width:70%"></textarea>		
		</div>
		</div>
		

		<div id="q13" class="soc-questions">
		<div id="q13Header" class="soc-question-header" >13. If threshold has been met (2 or more triggers) to trigger social work follow-up, caller will be offered a follow up call:</div>
		<div id="q13Content" class="soc-content" >
			"It sounds like you have some needs that have not been met by your initial call, I would like to have a social worker call you to see if we can help to meet your need. Would that be okay?
		    <br>
			<select name="soc_followupCall" >
				<option value="">Select</option>
				<option value="Yes">Yes</option>
				<option value="No" >No</option>
				<option value="NA" >NA</option>
			</select>
			<br>
			<ul type="square">
				<li>If YES, ask: "When is the best time for someone to call within the next day or two?"
					<br>
					<input type="text" name="soc_followupCallTime" style="width:70%;"/>
				</li>
				<li>If NO, "Thank you very much for taking the time to provide us with your feedback. Please call the support line anytime if we may be of further assistance."</li>
			</ul>
		</div>	
		</div>	    		


		<div id="q14" class="soc-questions">
		<div id="q14Header" class="soc-question-header" >14. If threshold has NOT been met (one or no triggers):</div>
		<div id="q14Content" class="soc-content" >
			Would you like to have a social worker call you to see if we can help to meet your need?
			    <br>
				<select name="soc_followupCall_q14" >
					<option value="">Select</option>
					<option value="Yes">Yes</option>
					<option value="No" >No</option>
					<option value="NA" >NA</option>
				</select>
				<br>
				<ul type="square">
					<li>If YES, ask: "When is the best time for someone to call within the next day or two?"
						<br>
						<input type="text" name="soc_followupCallTime_q14" style="width:70%;"/>
					</li>
					<li>If NO, "Thank you very much for taking the time to provide us with your feedback. Please call the support line anytime if we may be of further assistance."</li>
				</ul>
			<!-- 
			"Thank you very much for taking the time to provide us with your feedback. Please call the support line anytime if we may be of further assistance.
			-->
		</div>
		</div>


		<div id="qendCall" class="soc-questions ">
		<div id="qendCallHeader"   class="soc-question-header">END CALL</div>
		<div id="qendCallContent" ></div>
		</div>

		
		<div id="q15" class="soc-questions">
		<div id="q15Header" class="soc-question-header" >15. Threshold met: </div>
		<div id="q15Content" ></div>
			
		</div>	
	
	
		<div class="clear-both">
			<a href="javascript:" class="btn btn-primary" id="<portlet:namespace/>socSubmit" >
				<liferay-ui:message key="submit-soc" />
			</a>
			
			<a href="<portlet:actionURL/>" class="btn btn-primary" >
				<liferay-ui:message key="cancel" />
			</a>
		</div>
</form>

	<div class="yui3-skin-sam">
	    <div id="socValidationModal"></div>
	</div>

	<div id="socValidationDiv" class="yui3-skin-sam">
	    <div id="socValidationResult"></div>
	</div>


<aui:script use="aui-modal,aui-tooltip">

	var socModal = new A.Modal({
	    headerContent: '<h4><liferay-ui:message key="data-validation-header" /></h4>',
	    bodyContent: A.one("#socValidationDiv"),
	    centered: true,
	    destroyOnHide: false,
	    modal: true,
	    render: '#socValidationModal',
	    resizable: {
	      handles: 'b, r'
	    },
	    visible: false,
	    width: 600
	});
	
	
	A.one('#<portlet:namespace/>socSubmit').on('click', function ( event ) {
		
		if(null==A.one("input[name=<portlet:namespace/>soc_callerAvailable]:checked")){
    		socModal.render();
    		socModal.show();
    		var msg = "<div class='portlet-msg-alert'><liferay-ui:message key='please-address-required-fields' /><ul><li>SOC Question #1 is required</li></ul></div>";
    		A.one ('#socValidationResult').html(msg);
		}else{
			document.forms['socEntry'].submit();
		}
		
	});
	
	
	
	new A.TooltipDelegate( { trigger: '.show-tooltip' } );

	
	hideAll = function(){
		
		for (i = 1; i <= 15; i++) { 
			A.one('#q'+i+'Content' ).hide();
			A.one('#q'+i ).removeClass("soc-questions-expanded");
		}

		A.one('#qendCall' ).removeClass("soc-questions-expanded");				
	}	

	
	hideAll();
	A.one('#q1Content' ).show();
	A.one('#q1').addClass("soc-questions-expanded");	
	var ques = "q1";
	
	var callerAvailable = "";
	var willingToAnsQues="";
	var cslKnowledgable="";
	var concernsAnswered="";
	var understandNextSteps="";
	var callCslAgain="";
	var recommendCsl="";
	
	A.all('.soc-questions').on('click', function( event ){
		var quesId = event.currentTarget.attr('id');		   
		var quesNum = quesId.substring(1);
		
		if( quesId!=ques){
			hideAll();
			A.one('#'+quesId+'Content').show();	
			A.one('#'+quesId).addClass("soc-questions-expanded");
			ques=quesId;
		}
		
		
		if(quesNum == "1"){
			if(null!=A.one("input[name=<portlet:namespace/>soc_callerAvailable]:checked")){
				callerAvailable= A.one("input[name=<portlet:namespace/>soc_callerAvailable]:checked").get("value")
			}
		}
		if(quesNum == "2"){
			if(null!=A.one("input[name=<portlet:namespace/>soc_willingToAnsQues]:checked")){
				willingToAnsQues= A.one("input[name=<portlet:namespace/>soc_willingToAnsQues]:checked").get("value")
			}
		}

	
		var triggerNum=0;
		if(quesNum == "4"){
			if(null!=A.one("input[name=<portlet:namespace/>soc_cslKnowledgable]:checked")){
				cslKnowledgable= A.one("input[name=<portlet:namespace/>soc_cslKnowledgable]:checked").get("value");				
			}
		}
		if(quesNum == "8"){
			if(null!=A.one("input[name=<portlet:namespace/>soc_concernsAnswered]:checked")){
				concernsAnswered= A.one("input[name=<portlet:namespace/>soc_concernsAnswered]:checked").get("value");				
			}
		}
		if(quesNum == "9"){
			if(	null!=A.one("input[name=<portlet:namespace/>soc_understandNextSteps]:checked")){
				understandNextSteps= A.one("input[name=<portlet:namespace/>soc_understandNextSteps]:checked").get("value");
			}
		}
		if(quesNum == "10"){
			if(null!=A.one("input[name=<portlet:namespace/>soc_callCslAgain]:checked")){
				callCslAgain= A.one("input[name=<portlet:namespace/>soc_callCslAgain]:checked").get("value")
			}			
		}
		if(quesNum == "11"){
			if(null!=A.one("input[name=<portlet:namespace/>soc_recommendCsl]:checked")){
				recommendCsl= A.one("input[name=<portlet:namespace/>soc_recommendCsl]:checked").get("value")
			}
		}		
		
		
		if("Not Knowledgeable" == cslKnowledgable){
			triggerNum++;
		}
		if("No" == concernsAnswered){
			triggerNum++;
		}
		if("No" == understandNextSteps){
			triggerNum++;
		}
		if("Not Likely" == callCslAgain){
			triggerNum++;
		}
		if("Not Likely" == recommendCsl){
			triggerNum++;
		}


		if("No" == callerAvailable
			|| "No" == willingToAnsQues){
			A.one('#q13' ).hide();
			A.one('#q14' ).hide();	
			A.one ('#q15Header').html("15. Threshold met: No");
			A.one('#<portlet:namespace/>soc_tresholdMet').set("value","No");
		}else{
			if(triggerNum >= 2){
				A.one('#q13' ).show();
				A.one('#q14' ).hide();
				A.one ('#q15Header').html("15. Threshold met: Yes");
				A.one('#<portlet:namespace/>soc_tresholdMet').set("value","Yes");
			}else{
				A.one('#q13' ).hide();
				A.one('#q14' ).show();	
				A.one ('#q15Header').html("15. Threshold met: No");
				A.one('#<portlet:namespace/>soc_tresholdMet').set("value","No");
			}
		}
	});
</aui:script>


<script type="text/javascript">

	function hideDiv(start, end){
		for (i = start; i <= end; i++) { 
			var qId = 'q'+i;
			document.getElementById(qId).style.display = "none";
		}
	}
	

	function showDiv(start, end){
		for (i = start; i <= end; i++) { 
			var qId = 'q'+i;
			document.getElementById(qId).style.display = '';
		}
	}
	
</script>


